const database = require('./database');
const translator = require('./translator');
const commands = require('./commands');

class ClientFlowHandler {

  /**
   * Process department selection by client
   */
  async processDepartmentSelection(phone, message) {
    const state = commands.getClientState(phone);
    if (!state || state.step !== 'department') {
      return null;
    }

    const client = database.getClient(phone);
    const language = client?.language || 'en';
    const departments = database.listDepartments(true);
    
    const selection = parseInt(message.trim());
    
    if (isNaN(selection) || selection < 1 || selection > departments.length) {
      const errorEN = `❌ Invalid selection. Please send a number between 1 and ${departments.length}`;
      const error = await translator.translateMessage(errorEN, language);
      
      return {
        success: false,
        response: error
      };
    }

    const department = departments[selection - 1];
    
    // Create ticket with selected department
    const result = await commands.createTicketFromState(phone, department.id);
    
    return result;
  }

  /**
   * Check if client is in a flow that requires special handling
   */
  isClientInFlow(phone) {
    const state = commands.getClientState(phone);
    return state && state.flow === 'ticket_creation' && state.step === 'department';
  }
}

module.exports = new ClientFlowHandler();
